package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.widget.Toast;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.example.sefinsa_app.LoginActivity;
import com.example.sefinsa_app.R;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.gson.JsonParser;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class ErrorChecker {
    public static void showErrorMessage(String message, Context context) {
        new MaterialAlertDialogBuilder(context, R.style.AppMaterialAlertDialogStyle)
                .setTitle("Error")
                .setMessage(message)
                .setPositiveButton("OK", (dialog, which) -> {
                    // Acción que se ejecuta al presionar OK, si es necesario
                })
                .show();
    }
    public static int checker(VolleyError error, Context context){
        String message = null;
        int TYPE_ERROR = 0;
        if (error instanceof NetworkError) {

            Toast.makeText(context, "Te has desconectado de internet, revisa tu conexión", Toast.LENGTH_LONG).show();
                TYPE_ERROR = 1; // Tipo de error de conexión


        } else if (error instanceof ServerError) {
            message = "The server could not be found. Please try again after some time!!2";
            String body;
            String statusCode = String.valueOf(error.networkResponse.statusCode);
           if(statusCode.equals("500")){

                new MaterialAlertDialogBuilder(context)
                        .setTitle("Aviso")
                        .setMessage("Error del servidor, comunicate con el equipo de soporte")
                        .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        })
                        .show();
                TYPE_ERROR = 3;

            }
            else{

                if(error.networkResponse.data!=null) {
                    try {
                        body = new String(error.networkResponse.data, StandardCharsets.UTF_8);

                        JSONObject json = new JSONObject(body);
                        String mensaje = json.get("message").toString();

                        new MaterialAlertDialogBuilder(context)
                                .setTitle("Aviso")
                                .setMessage(mensaje)
                                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                    }
                                })
                                .show();

                        TYPE_ERROR = 2;
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

            }

        } else if (error instanceof AuthFailureError) {

                message = "Cannot connect to Internet...Please check your connection!3";
            Toast.makeText(context, "Te has desconectado de internet, revisa tu conexión", Toast.LENGTH_LONG).show();
                TYPE_ERROR = 4;


        } else if (error instanceof ParseError) {
            Log.e("error", error.getMessage());
            new MaterialAlertDialogBuilder(context)
                    .setTitle("Aviso")
                    .setMessage("Error de código, comunicate con el equipo de soporte")
                    .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    })
                    .show();
            TYPE_ERROR = 5;

        } else if (error instanceof NoConnectionError) {

                message = "Cannot connect to Internet...Please check your connection!5";
            Toast.makeText(context, "Te has desconectado de internet, revisa tu conexión", Toast.LENGTH_LONG).show();
                TYPE_ERROR = 1;


        } else if (error instanceof TimeoutError) {
            message = "Connection TimeOut! Please check your internet connection.6";
            new MaterialAlertDialogBuilder(context)
                    .setTitle("Aviso")
                    .setMessage("Tiempo de espera excedido, vuelve a intentarlo")
                    .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    })
                    .show();

            TYPE_ERROR = 6;

        }

        return TYPE_ERROR;


    }

}
